#include <Goertzel.h>
#include "params.h"

/*
02/12/2025 - aggiunta LCD e RTC

- versione completa dello sketch per la decodifica del segnale orario (32+16)
include ricerca 5 toni a 1000Hz e integrazione decodifica dei bit al 52"

https://en.wikipedia.org/wiki/JN53DV

*/

//installare la libreria rtclib di adafruit

#include <Wire.h>
#include <RTClib.h>
RTC_DS3231 rtc;

// installare HD44780_LCD_PCF8574 arduino library 
#include <HD44780_LCD_PCF8574.h>
HD44780LCD myLCD(2, 16, 0x27, &Wire); 
char str1[20];
char str2[20];
//const char testo1[] PROGMEM = "Radio Segnale";

// Sketch di decodifica FSK
float offset = 0;
//#define SAMPLE_RATE 8800
#define SAMPLES_NUM 50 
//era 100
int Samples[SAMPLES_NUM];
Goertzel TONE(1000.0);
Goertzel TONEHI(2000.0);
Goertzel TONELO(2500.0);

unsigned long tone1000_space = 1000;
const unsigned long tone1000_time_offset = 100;

int state = 0;

bool FIRST = true;

unsigned long t1, t2, t1wd; //timer software

int tones1000_count = 0;
int tone1000, pv_tone1000;
int tone2000, pv_tone2000;
int tone2500, pv_tone2500;

//variabili con la potenza dei segnali ricevuti
float f1, f2, f3;
int c = 0; //contatore di servizio

//detect dei silenzi tra le sequenze di bit
bool SILENCE, pv_SILENCE;
unsigned long tsil;

bool PRINT_DATA; //debug per stampare dati se necessario

int buff_index = 0;

uint8_t buff[50];

//struttura con data e ora ricevute
RadioDateTime now;

void setup() {
  Serial.begin(115200);

  //SEtup display
  myLCD.PCF8574_LCDInit(myLCD.LCDCursorTypeOn);
  myLCD.PCF8574_LCDClearScreen();
  myLCD.PCF8574_LCDBackLightSet(true);
  myLCD.PCF8574_LCDGOTO(myLCD.LCDLineNumberOne, 0);

  myLCD.PCF8574_LCDSendString("Radio segnale");
  delay(1000);
  myLCD.PCF8574_LCDClearScreen();

  //setup dell'RTC
  if (!rtc.begin()) {
    myLCD.PCF8574_LCDClearScreen();
    myLCD.PCF8574_LCDGOTO(myLCD.LCDLineNumberOne, 0);
    myLCD.PCF8574_LCDSendString("errore RTC");
    Serial.println("Controlla le connessioni");
    while(true);
  }
  if (rtc.lostPower()) {
    Serial.println("Imposto data/ora");
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));   
    // rtc.adjust(DateTime(2014, 1, 21, 3, 0, 0));
  }

  //usa i pin A1 e A2 per visualizzare i bit
  pinMode(A1, OUTPUT);
  pinMode(A2, OUTPUT);
  pinMode(A3, OUTPUT); //1000hz

  //centraggio
  for (int i = 0; i < 10; i++){
    offset += analogRead(A0);
    delay(10);
  }
  offset = offset / 10;
}

void loop() {
  // Get 100 ADC samples
  for (int n = 0; n < SAMPLES_NUM; n++) {
    Samples[n] = analogRead(A0);
  }

  //verifico che note si attivano
  float f1 = TONE.Mag(Samples, SAMPLES_NUM);  
  if (f1 > 5000) {
    tone1000 = HIGH;
    digitalWrite(A3, HIGH);
  } else {
    tone1000 = LOW;
    digitalWrite(A3, LOW);
  }

  float f2 = TONEHI.Mag(Samples, SAMPLES_NUM);  
  if (f2 > 2000) {
    tone2500 = HIGH;
    digitalWrite(A1, HIGH);
  } else {
    tone2500 = LOW;
    digitalWrite(A1, LOW);
  }

  float f3 = TONELO.Mag(Samples, SAMPLES_NUM);  
  if (f3 > 4000) {
    tone2000 = HIGH;
    digitalWrite(A2, HIGH);
  } else {
    tone2000 = LOW;
    digitalWrite(A2, LOW);
  }
  
  /*
  Serial.print(0);Serial.print(", ");Serial.print(5000);Serial.print(", ");
  Serial.print(f2);Serial.print(", ");
  Serial.print(f3);Serial.print(", ");
  Serial.println(f1);
  */

  switch (state) {
    case 0:
      //wait 4 sincro (1000Hz)
      wait_4_first_1000();
      break;
    case 1:
      //count 1000Hz tones (1 per second) 5 + 1
      count_1000_tones();
      break;
    case 2:
      //segnale sincronizzato - attendo 52 secondi
      sincro_wait_52();
      updatelcd();
      break;
    case 3:
      //decodifica bit
      decode_chunk();
      break;
  }

  pv_tone1000 = tone1000;
  pv_tone2000 = tone2000;
  pv_tone2500 = tone2500;
}

void updatelcd(){
  static unsigned long t1 = millis();
  if ((millis() - t1) > 1000) {
    DateTime now = rtc.now();
    
    sprintf(str1, "%02d:%02d           ",
          now.hour(),
          now.minute());
    sprintf(str2, "%04d-%02d-%02d      ",
          now.year(),
          now.month(),
          now.day());
    //myLCD.PCF8574_LCDClearScreen();
    myLCD.PCF8574_LCDGOTO(myLCD.LCDLineNumberOne, 0);
    myLCD.PCF8574_LCDSendString(str1); 
    myLCD.PCF8574_LCDGOTO(myLCD.LCDLineNumberTwo, 0);
    myLCD.PCF8574_LCDSendString(str2); 
    t1 = millis();
  }
}
