
void decodeJN53DV(uint8_t* buff, RadioDateTime& tm){
  tm.year = 0;
  if (!buff[0] && buff[1]) {
    tm.hour = extractHour(buff);
    tm.minute = extractMinute(buff);
    tm.summertime = buff[15];
    tm.month = extractMonth(buff);
    tm.day = extractDay(buff);
    tm.weekday = extractWeekDay(buff);
    tm.p1 = buff[16];
    tm.p2 = buff[31];
  } else {
    tm.error = -1;
  }

  //verifica parità
  int p = 0;
  for (int i = 0; i < 15; i++){
    p += buff[i];
  }
  Serial.print(p);Serial.print(" ");Serial.print(tm.p1);
  if ((p%2) == tm.p1) {
    Serial.print(" P1=ok "); 
    //aggiorno l'RTC - ora e min
    DateTime now = rtc.now();
    rtc.adjust(DateTime(now.year(), now.month(), now.day(), tm.hour, tm.minute, 0));
  } else {
    Serial.print(" P1=ko ");
  }
  //P2
  p = 0;
  for (int i = 17; i < 30; i++){
    p += buff[i];
  }
  Serial.print(p);Serial.print(" ");Serial.print(tm.p2);
  if ((p%2) == tm.p2) {
    Serial.print(" P2=ok"); 
  } else {
    Serial.print(" P2=ko");
  }
  
  const int oft = 0;
  //parte 2
  if (buff[32+oft] && !buff[33+oft]) {
    tm.year = extractYear(buff);
    tm.summertime_warning = extractSummerTimeWarning(buff);
    //tm.s1 = buff[45];
    //tm.s2 = buff[46];
    //tm.p3 = buff[47];
  }  else {
    tm.error = -2;
  }
  //P3
  p = 0;
  for (int i = 32; i < 47; i++){
    p += buff[i];
  }
  Serial.print(p);Serial.print(" ");Serial.print(tm.p3);
  if ((p%2) == tm.p3) {
    Serial.print(" P3=ok");
    //aggiorno l'RTC - data
    //DateTime now = rtc.now();
    //rtc.adjust(DateTime(now.year(), now.month(), now.day(), tm.hour, tm.minute, 0));

  } else {
    Serial.print(" P3=ko");
  }
}

void printDateTime(const RadioDateTime& dt) {
  if (dt.error < 0) {
    Serial.println("Not valid sequence");
  } else {
    Serial.print("Data: ");
    Serial.print(dt.day);
    Serial.print("/");
    Serial.print(dt.month);
    Serial.print("/");
    Serial.print(dt.year);
    Serial.print(" - Ora: ");
    Serial.print(dt.hour);
    Serial.print(":");
    Serial.print(dt.minute);
    Serial.print(":");
    Serial.print(dt.second);

    Serial.print("\t wday:");
    Serial.print(dt.weekday);
    Serial.print(" - Summertime: ");
    Serial.println(dt.summertime);
    
  }
}

int extractHour(const uint8_t* buff) {
  const int weights[6] = {20, 10, 8, 4, 2, 1};
  int hour = 0;

  for (int i = 0; i < 6; i++) {
    if (buff[2 + i]) {
      hour += weights[i];
    }
  }

  return hour;
}

int extractMinute(const uint8_t* buff) {
  const int weights[7] = {40, 20, 10, 8, 4, 2, 1};
  int minute = 0;

  for (int i = 0; i < 7; i++) {
    if (buff[8 + i]) {
      minute += weights[i];
    }
  }

  return minute;
}

int extractMonth(const uint8_t* buff) {
  const int weights[5] = {10, 8, 4, 2, 1};
  int n = 0;
  for (int i = 0; i < 5; i++) {
    if (buff[17 + i]) {
      n += weights[i];
    }
  }
  return n;
}

int extractDay(const uint8_t* buff) {
  const int weights[6] = {20, 10, 8, 4, 2, 1};
  int n = 0;
  for (int i = 0; i < 6; i++) {
    if (buff[22 + i]) {
      n += weights[i];
    }
  }
  return n;
}

int extractWeekDay(const uint8_t* buff) {
  const int weights[3] = {4, 2, 1};
  int n = 0;
  for (int i = 0; i < 3; i++) {
    if (buff[28 + i]) {
      n += weights[i];
    }
  }
  return n;
}

int extractYear(const uint8_t* buff) {
  const int weights[8] = {80, 40, 20, 10, 8, 4, 2, 1};
  int n = 0;
  //Serial.print("Y:");
  for (int i = 0; i < 8; i++) {
    if (buff[34 + i]) {
      //Serial.print(buff[34+ 2 + i]);
      n += weights[i];
    }
  }
  //Serial.println("");
  return n;
}

int extractSummerTimeWarning(const uint8_t* buff) {
  const int weights[3] = {4, 2, 1};
  int n = 0;
  for (int i = 0; i < 3; i++) {
    if (buff[42 + 2 + i]) {
      n += weights[i];
    }
  }
  return n;
}

void print_data(){
  Serial.print("read: ");Serial.print(buff_index);
  Serial.println(" ");
  //Serial.println("01010110 01000001 10011010 01111011_10001001 01111000");
  for (int i = 0; i < buff_index; i++) {
    Serial.print(buff[i]);
    if (i%8 == 7) Serial.print(" ");
  }
  Serial.println("-");
  //potrei dividere la decodifica in parte 1
  decodeJN53DV(buff, now);
  // e parte 2
  //decodeJN53DV_Year(buff, now);

  printDateTime(now);
  //buff_index = 0;
}

