void go(int st){
  state = st;
  FIRST = true;
}

void wait_4_first_1000(){
  if (FIRST) {
    Serial.println("S0");
    FIRST = false;
    tones1000_count = 0;
  }
  if (pv_tone1000 && !tone1000) {
    //trovato il primo tono, inizio a contare
    tones1000_count++;
    go(1);
  }
}

void count_1000_tones() {
  if (FIRST) {
    t1 = millis();
    t1wd = t1;  //watchdog/timeout
    FIRST = false;
    tone1000_space = 1000;
    Serial.println("S1 - counting");
  } 

  if ((millis()-t1wd) > 5000) {
    //timeout
    go(0);
  }

  //fronte di discesa - 
  if (pv_tone1000 && !tone1000) { 
    //Serial.println( (millis()-t1) );

    if ((millis()-t1 > tone1000_space-tone1000_time_offset) 
      && (millis()-t1 < tone1000_space+tone1000_time_offset)) {
      tones1000_count++;
      Serial.println(tones1000_count);
      t1 = millis();
      //azzero il watchdog
      t1wd = t1;

      if (tones1000_count == 5) {
        tone1000_space = 2000;
      } else if (tones1000_count == 6) {
        go(2);
      }
    } 
  }
}

void sincro_wait_52(){
  static int c = 0; //contatore secondi
  static unsigned long tc = 0;
  if (FIRST) {
    FIRST = false;
    Serial.println("S2 - wait 52");
    t1 = millis();
    t2 = t1;
    c = 0;
    tc = 0;
  }
  unsigned long dt = (millis()-t1);
  if (millis()-t2 >= 51100) {
    //inizia la decodifica
    go(3);
  }

  if (dt > 970) {
    t1 = millis();
    tc += dt;
    c++;
    if (c <= 51) {
      Serial.print(tc);Serial.print("ms\tc:");Serial.println(c);
    }
  }
}

void decode_chunk(){
  if (FIRST) {
    FIRST = false;
    buff_index = 0;
    Serial.println("S3 - decoding");
    t1 = millis();
  }

  //intercetto l'inizio e la fine delle note
  //all'inizio della nota attivo un timer
  //che uso per misurare il tempo tra FDS e FDD
  // se ho tre 111 di seguito, la nota dura 3 volte tanto ed ho un solo FDS e un FDD!
  if (!pv_tone2500 && tone2500) { //FDS
    t1 = millis();
  }
  if (pv_tone2500 && !tone2500) {
    for (int i = 0; i < ((millis()-t1) / 30); i++) {
      buff[buff_index++] = 0x01;
      //Serial.print(1);
      //Serial.println(buff_index);
    }
    //Serial.println((millis()-t1) / 30 );
  }

  if (!pv_tone2000 && tone2000) {
    t2 = millis();
  }
  if (pv_tone2000 && !tone2000) {
    //Serial.print(">");Serial.println((millis()-t2) / 30 );
    for (int i = 0; i < ((millis()-t2) / 30); i++) {
      buff[buff_index++] = 0x00;
      //Serial.print(0);
    }
  }  

  //misuro i silenzi
  if (!tone2500 && !tone2000 && !tone1000){
    SILENCE = true;
  } else {
    SILENCE = false;
  }
  if (!pv_SILENCE && SILENCE){
    //start silenzio
    //Serial.println("sil");
    tsil = millis();
    //attivo la stampa (tra 1 secondo)
    PRINT_DATA = false;
  }
  if (pv_SILENCE && SILENCE){
    //silenzio
    //Serial.print("sil: ");
    //Serial.println(millis()-tsil);
    if (((millis()-tsil) > 100) && !PRINT_DATA) {
      print_data();
      //abilita stampa risultato
      PRINT_DATA = true;
      //RESET lettura
      buff_index = 0;
      go(0);
    }
  }
  if (pv_SILENCE && !SILENCE){
    //end silenzio
    //Serial.print("sil: ");
    //Serial.println(millis()-tsil);
  }
  pv_SILENCE = SILENCE;
}

